/*
 * Customizer.js to reload changes on Theme Customizer Preview asynchronously.
 *
 */

( function( $ ) {

	/* Theme Colors */	
	var menu_primary_color = '#333333';
	var menu_secondary_color = '#e84747';
	var post_primary_color = '#333333';
	var post_secondary_color = '#e84747';
	
	wp.customize( 'dynamicnews_theme_options[menu_primary_color]', function( value ) {
		value.bind( function( newval ) {
			menu_primary_color = newval;
			$('#logo a')
				.hover( function() { $( this ).find('.site-title').css('color', newval ); },
						function() { $( this ).find('.site-title').css('color', menu_secondary_color ); }
				);
			$('#navi-wrap')
				.css('background', newval );
			$('#social-icons-menu li a')
				.hover( function() { $( this ).css('background', newval ); },
						function() { $( this ).css('background', menu_secondary_color ); }
				);
		} );
	} );
	
	wp.customize( 'dynamicnews_theme_options[menu_secondary_color]', function( value ) {
		value.bind( function( newval ) {
			menu_secondary_color = newval;
			$('#logo .site-title')
				.css('color', newval );
			$('#social-icons-menu li a')
				.css('background', newval );
			$('#mainnav-menu a, #mainnav-icon')
				.hover( function() { $( this ).css('background', newval ); },
						function() { $( this ).css('background', menu_primary_color ); }
				);
			$('#mainnav-menu ul a')
				.hover( function() { $( this ).css('background', newval ); },
						function() { $( this ).css('background', '#ffffff' ); }
				);
		} );
	} );
	
	wp.customize( 'dynamicnews_theme_options[post_primary_color]', function( value ) {
		value.bind( function( newval ) {
			post_primary_color = newval;
			$('.page-title, .post-title, .post-title a:link, .post-title a:visited, .archive-title span, .postmeta a:link, .postmeta a:visited, #comments .comments-title, #respond #reply-title')
				.css('color', newval );
			$('.post-title a')
				.hover( function() { $( this ).css('color', post_secondary_color ); },
						function() { $( this ).css('color', newval ); }
				);
			$('.postinfo .meta-category a')
				.css('background', newval );
			$('.postinfo .meta-category a')
				.hover( function() { $( this ).css('background', post_secondary_color ); },
						function() { $( this ).css('background', newval ); }
				);
			$('input[type="submit"], .more-link, #commentform #submit')
				.hover( function() { $( this ).css('background', newval ); },
						function() { $( this ).css('background', post_secondary_color ); }
				);
			$('.page-title, .post-title, #comments .comments-title, #respond #reply-title')
				.css('border-bottom', '5px solid' + newval );
		} );
	} );
	
	wp.customize( 'dynamicnews_theme_options[post_secondary_color]', function( value ) {
		value.bind( function( newval ) {
			post_secondary_color = newval;
			$('.entry a, .entry a:link, .entry a:visited, .comment a:link, .comment a:visited, .archive-title span, .post-pagination a:link, .post-pagination a:visited')
				.not( $('.more-link:link, .more-link:visited, .postmeta a:link, .postmeta a:visited') )
				.css('color', newval );
			$('.post-title a')
				.hover( function() { $( this ).css('color', newval ); },
						function() { $( this ).css('color', post_primary_color ); }
				);
			$('.bypostauthor .fn, .comment-author-admin .fn, input[type="submit"], .more-link, #commentform #submit')
				.css('background', newval );
			$('.postinfo .meta-category a')
				.hover( function() { $( this ).css('background', newval ); },
						function() { $( this ).css('background', post_primary_color ); }
				);
		} );
	} );
	
	wp.customize( 'dynamicnews_theme_options[widget_title_color]', function( value ) {
		value.bind( function( newval ) {
			$('#sidebar .widgettitle, #sidebar .widget-tabnav li a:hover, #frontpage-magazine-widgets .widget .widgettitle')
				.css('background', newval );
			
		} );
	} );
	
	wp.customize( 'dynamicnews_theme_options[widget_link_color]', function( value ) {
		value.bind( function( newval ) {
			$('#sidebar .widget a:link, #sidebar .widget a:visited')
				.not( $('.widget-tabnav li a, .widget-tabnav li a:link, .widget-tabnav li a:visited') )
				.css('color', newval );
		} );
	} );
	
	wp.customize( 'dynamicnews_theme_options[footer_color]', function( value ) {
		value.bind( function( newval ) {
			$('#footer-wrap, #footer-widgets-bg')
				.css('background', newval );
		} );
	} );
	
	
	/* Theme Fonts */	
	wp.customize( 'dynamicnews_theme_options[text_font]', function( value ) {
		value.bind( function( newval ) {
		
			// Embed Font
			var fontFamilyUrl = newval.split(" ").join("+");
			var googleFontPath = "http://fonts.googleapis.com/css?family="+fontFamilyUrl;
			var googleFontSource = "<link id='dynamicnews-pro-custom-text-font' href='"+googleFontPath+"' rel='stylesheet' type='text/css'>";					
			var checkLink = $("head").find("#dynamicnews-pro-custom-text-font").length;
			
			if (checkLink > 0) {
				$("head").find("#dynamicnews-pro-custom-text-font").remove();
			}
			$("head").append(googleFontSource);
			
			// Set CSS
			$('body, input, textarea')
				.css('font-family', newval );
				
		} );
	} );
	
	wp.customize( 'dynamicnews_theme_options[title_font]', function( value ) {
		value.bind( function( newval ) {
		
			// Embed Font
			var fontFamilyUrl = newval.split(" ").join("+");
			var googleFontPath = "http://fonts.googleapis.com/css?family="+fontFamilyUrl;
			var googleFontSource = "<link id='dynamicnews-pro-custom-title-font' href='"+googleFontPath+"' rel='stylesheet' type='text/css'>";					
			var checkLink = $("head").find("#dynamicnews-pro-custom-title-font").length;
			
			if (checkLink > 0) {
				$("head").find("#dynamicnews-pro-custom-title-font").remove();
			}
			$("head").append(googleFontSource);
			
			// Set CSS
			$('#logo .site-title, .page-title, .post-title, #frontpage-slider .zeeslide .slide-entry .slide-title, #comments .comments-title, #respond #reply-title')
				.css('font-family', newval );
				
		} );
	} );
	
	wp.customize( 'dynamicnews_theme_options[navi_font]', function( value ) {
		value.bind( function( newval ) {
		
			// Embed Font
			var fontFamilyUrl = newval.split(" ").join("+");
			var googleFontPath = "http://fonts.googleapis.com/css?family="+fontFamilyUrl;
			var googleFontSource = "<link id='dynamicnews-pro-custom-navi-font' href='"+googleFontPath+"' rel='stylesheet' type='text/css'>";					
			var checkLink = $("head").find("#dynamicnews-pro-custom-navi-font").length;
			
			if (checkLink > 0) {
				$("head").find("#dynamicnews-pro-custom-navi-font").remove();
			}
			$("head").append(googleFontSource);
			
			// Set CSS
			$('#mainnav-icon, #mainnav-menu a')
				.css('font-family', newval );
				
		} );
	} );
	
	wp.customize( 'dynamicnews_theme_options[widget_title_font]', function( value ) {
		value.bind( function( newval ) {
		
			// Embed Font
			var fontFamilyUrl = newval.split(" ").join("+");
			var googleFontPath = "http://fonts.googleapis.com/css?family="+fontFamilyUrl;
			var googleFontSource = "<link id='dynamicnews-pro-custom-widget-title-font' href='"+googleFontPath+"' rel='stylesheet' type='text/css'>";					
			var checkLink = $("head").find("#dynamicnews-pro-custom-widget-title-font").length;
			
			if (checkLink > 0) {
				$("head").find("#dynamicnews-pro-custom-widget-title-font").remove();
			}
			$("head").append(googleFontSource);
			
			// Set CSS
			$('.widgettitle, #frontpage-magazine-widgets .widget .widgettitle')
				.css('font-family', newval );
				
		} );
	} );

} )( jQuery );