<?php
/*
 * Footer Text
 * 
 * Removes default Credit Link and displays Footer Text
 *
 */

// Remove default footer text
remove_action( 'dynamicnews_footer_text', 'dynamicnews_display_footer_text' );

// Display Footer Widgets on Dynamic News
add_action( 'dynamicnews_footer_text', 'dynamicnews_pro_display_footer_text' );

// Display Site Title
function dynamicnews_pro_display_footer_text() { 

	// Get Theme Options from Database
	$theme_options = dynamicnews_pro_theme_options();
				
	if ( isset( $theme_options['footer_text'] ) and $theme_options['footer_text'] <> '' ) :
		
		echo do_shortcode(wp_kses_post($theme_options['footer_text']));
			
	endif; 
	
	// Display Credit Link only if activated
	if ( isset($theme_options['credit_link']) and $theme_options['credit_link'] == true ) :
	
		echo ' <span class="credit-link">';
		printf(__( 'Powered by %1$s and %2$s.', 'dynamicnews' ), 
				sprintf( '<a href="http://wordpress.org" title="WordPress">%s</a>', __( 'WordPress', 'dynamicnews' ) ),
				sprintf( '<a href="http://themezee.com/themes/dynamicnews/" title="Dynamic News WordPress Theme">%s</a>', __( 'Dynamic News', 'dynamicnews' ) )
			);
		echo '</span>';
		
	endif;

}

?>