<?php
/**
 * Register Header Content section, settings and controls for Theme Customizer
 *
 */

// Add Theme Colors section to Customizer
add_action( 'customize_register', 'dynamicnews_pro_customize_register_header_settings' );

function dynamicnews_pro_customize_register_header_settings( $wp_customize ) {

	// Add Upload logo image setting
	$wp_customize->add_setting( 'dynamicnews_theme_options[header_logo]', array(
        'default'           => '',
		'type'           	=> 'option',
        'transport'         => 'refresh',
        'sanitize_callback' => 'esc_url'
		)
	);
	$wp_customize->add_control( new WP_Customize_Image_Control(
		$wp_customize, 'dynamicnews_control_header_logo', array(
			'label'    => __( 'Logo Image (replaces Site Title)', 'dynamicnews-pro' ),
			'section'  => 'dynamicnews_section_header',
			'settings' => 'dynamicnews_theme_options[header_logo]',
			'priority' => 1,
			)
		)
	);
	
	// Add Header Padding setting
	$wp_customize->add_setting( 'dynamicnews_theme_options[header_padding]', array(
        'default'           => false,
		'type'           	=> 'option',
        'transport'         => 'refresh',
        'sanitize_callback' => 'dynamicnews_pro_sanitize_checkbox'
		)
	);
    $wp_customize->add_control( 'dynamicnews_control_header_padding', array(
        'label'    => __( 'Remove spacing on header area for fullwidth logo images.', 'dynamicnews-pro' ),
        'section'  => 'dynamicnews_section_header',
        'settings' => 'dynamicnews_theme_options[header_padding]',
        'type'     => 'checkbox',
		'priority' => 2
		)
	);

}

?>