<?php
/**
 * Register General section, settings and controls for Theme Customizer
 *
 */

// Add Theme Colors section to Customizer
add_action( 'customize_register', 'dynamicnews_pro_customize_register_general_settings' );

function dynamicnews_pro_customize_register_general_settings( $wp_customize ) {

	// Add Footer Settings
	$wp_customize->add_setting( 'dynamicnews_theme_options[footer_text]', array(
        'default'           => '',
		'type'           	=> 'option',
        'transport'         => 'refresh',
        'sanitize_callback' => 'dynamicnews_pro_sanitize_footer_text'
		)
	);
    $wp_customize->add_control( 'dynamicnews_control_footer_text', array(
        'label'    => __( 'Footer Text', 'dynamicnews-pro' ),
        'section'  => 'dynamicnews_section_general',
        'settings' => 'dynamicnews_theme_options[footer_text]',
        'type'     => 'textarea',
		'priority' => 3
		)
	);
	$wp_customize->add_setting( 'dynamicnews_theme_options[credit_link]', array(
        'default'           => true,
		'type'           	=> 'option',
        'transport'         => 'refresh',
        'sanitize_callback' => 'dynamicnews_pro_sanitize_checkbox'
		)
	);
    $wp_customize->add_control( 'dynamicnews_control_credit_link', array(
        'label'    => __( 'Display Credit Link to ThemeZee on footer line.', 'dynamicnews-pro' ),
        'section'  => 'dynamicnews_section_general',
        'settings' => 'dynamicnews_theme_options[credit_link]',
        'type'     => 'checkbox',
		'priority' => 4
		)
	);
	
	// Remove default Deactivate Google Fonts Setting
	$wp_customize->remove_control('dynamicnews_control_default_fonts');
	$wp_customize->remove_control('dynamicnews_control_deactivate_google_fonts');
	
}

?>