<?php
/**
 * Register Theme Font section, settings and controls for Theme Customizer
 *
 */

// Add Theme Fonts section to Customizer
add_action( 'customize_register', 'dynamicnews_pro_customize_register_font_settings' );

function dynamicnews_pro_customize_register_font_settings( $wp_customize ) {

	// Add Section for Theme Fonts
	$wp_customize->add_section( 'dynamicnews_pro_section_fonts', array(
        'title'    => __( 'Theme Fonts', 'dynamicnews-pro' ),
        'priority' => 70,
		'panel' => 'dynamicnews_options_panel' 
		)
	);
	
	// Get Default Fonts from settings
	$default_options = dynamicnews_pro_default_options();

	// Add settings and controls for theme fonts
	$wp_customize->add_setting( 'dynamicnews_theme_options[text_font]', array(
        'default'           => $default_options['text_font'],
		'type'           	=> 'option',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'esc_attr'
		)
	);
	$wp_customize->add_control( new Dynamic_News_Pro_Customize_Font_Control( 
		$wp_customize, 'text_font', array(
			'label'      => __( 'Default Text Font', 'dynamicnews-pro' ),
			'section'    => 'dynamicnews_pro_section_fonts',
			'settings'   => 'dynamicnews_theme_options[text_font]',
			'priority' => 1
		) ) 
	);
	
	$wp_customize->add_setting( 'dynamicnews_theme_options[title_font]', array(
        'default'           => $default_options['title_font'],
		'type'           	=> 'option',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'esc_attr'
		)
	);
	$wp_customize->add_control( new Dynamic_News_Pro_Customize_Font_Control( 
		$wp_customize, 'title_font', array(
			'label'      => __( 'Title Font', 'dynamicnews-pro' ),
			'section'    => 'dynamicnews_pro_section_fonts',
			'settings'   => 'dynamicnews_theme_options[title_font]',
			'priority' => 2
		) ) 
	);
	
	$wp_customize->add_setting( 'dynamicnews_theme_options[navi_font]', array(
        'default'           => $default_options['navi_font'],
		'type'           	=> 'option',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'esc_attr'
		)
	);
	$wp_customize->add_control( new Dynamic_News_Pro_Customize_Font_Control( 
		$wp_customize, 'navi_font', array(
			'label'      => __( 'Navigation Font', 'dynamicnews-pro' ),
			'section'    => 'dynamicnews_pro_section_fonts',
			'settings'   => 'dynamicnews_theme_options[navi_font]',
			'priority' => 3
		) ) 
	);
	
	$wp_customize->add_setting( 'dynamicnews_theme_options[widget_title_font]', array(
        'default'           => $default_options['widget_title_font'],
		'type'           	=> 'option',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'esc_attr'
		)
	);
	$wp_customize->add_control( new Dynamic_News_Pro_Customize_Font_Control( 
		$wp_customize, 'widget_title_font', array(
			'label'      => __( 'Widget Title Font', 'dynamicnews-pro' ),
			'section'    => 'dynamicnews_pro_section_fonts',
			'settings'   => 'dynamicnews_theme_options[widget_title_font]',
			'priority' => 4
		) ) 
	);
	
	// Choose Available Fonts
	$wp_customize->add_setting( 'dynamicnews_theme_options[available_fonts]', array(
        'default'           => 'favorites',
		'type'           	=> 'option',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'dynamicnews_pro_sanitize_available_fonts'
		)
	);
	$wp_customize->add_control( new Dynamic_News_Pro_Customize_Font_List_Control( 
		$wp_customize, 'dynamicnews_control_available_fonts', array(
			'label'      => __( 'Choose available Fonts', 'dynamicnews-pro' ),
			'section'    => 'dynamicnews_pro_section_fonts',
			'settings'   => 'dynamicnews_theme_options[available_fonts]',
			'choices' => array(
				'default' => __( 'Default Browser Fonts (12)', 'dynamicnews-pro' ),
				'favorites' => __( 'ThemeZee Favorite Fonts (35)', 'dynamicnews-pro' ),
				'popular' => __( 'Most Popular Google Fonts (100)', 'dynamicnews-pro' ),
				'all' => __( 'All Google Fonts (650)', 'dynamicnews-pro' )
				),
			'priority' => 5
		) ) 
	);
	
}


?>