<?php
/**
 * Theme Customizer Functions
 *
 */

/*========================== CUSTOMIZER CONTROLS FUNCTIONS ==========================*/

// Add simple heading option to the theme customizer
if ( class_exists( 'WP_Customize_Control' ) ) :

    class Dynamic_News_Pro_Customize_Header_Control extends WP_Customize_Control {

        public function render_content() {  ?>
			
			<label>
				<span class="customize-control-title"><?php echo wp_kses_post( $this->label ); ?></span>
			</label>
			
<?php
        }
    }
	
	class Dynamic_News_Pro_Customize_Description_Control extends WP_Customize_Control {

        public function render_content() {  ?>
			
			<span class="description"><?php echo wp_kses_post( $this->label ); ?></span>
			
<?php
        }
    }
	
	class Dynamic_News_Pro_Customize_Font_List_Control extends WP_Customize_Control {
	
		// critical for JS constructor
		public $type = 'dynamicnews_pro_custom_font_list';
		
		public $l10n = array();
		
		public function __construct($manager, $id, $args = array(), $options = array()) {
		
			// Make Buttons translateable
			$this->l10n = array(
				'update' =>	__( 'Update Fonts', 'dynamicnews-pro' )
			);
			
			parent::__construct( $manager, $id, $args );
			
		}
		
		public function enqueue() {

			// Register and Enqueue Custom Font JS Constructor
			wp_enqueue_script( 'dynamicnews-pro-custom-font-control', plugins_url('/js/custom-font-control.js', dirname(dirname(dirname(__FILE__)) )), array( 'customize-controls' ), '', true );
		
		}
		
		public function render_content() {
		
			if ( empty( $this->choices ) )
				return;
				
			// Create Data Attributes with font lists
			$default = json_encode(Dynamic_News_Pro_Custom_Font_Lists::get_fonts('default'));
			$favorite = json_encode(Dynamic_News_Pro_Custom_Font_Lists::get_fonts('favorite'));
			$popular = json_encode(Dynamic_News_Pro_Custom_Font_Lists::get_fonts('popular'));
			$all = json_encode(Dynamic_News_Pro_Custom_Font_Lists::get_fonts('all'));
			
			$l10n = json_encode( $this->l10n );

			?>
			<label>
				<?php if ( ! empty( $this->label ) ) : ?>
					<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<?php endif;
				if ( ! empty( $this->description ) ) : ?>
					<span class="description customize-control-description"><?php echo $this->description; ?></span>
				<?php endif; ?>

				<select <?php $this->link(); ?>>
					<?php
					foreach ( $this->choices as $value => $label )
						echo '<option value="' . esc_attr( $value ) . '"' . selected( $this->value(), $value, false ) . '>' . $label . '</option>';
					?>
				</select>
				<div class="actions"></div>
				<div class="custom-font-lists" data-l10n="<?php echo esc_attr( $l10n ); ?>" data-standard="<?php echo esc_attr( $default ); ?>" data-favorite="<?php echo esc_attr( $favorite ); ?>" data-popular="<?php echo esc_attr( $popular ); ?>" data-all="<?php echo esc_attr( $all ); ?>"></div>
				<div class="debugging"></div>
			</label>
			
		<?php
		}
		
	}
		
		
	class Dynamic_News_Pro_Customize_Font_Control extends WP_Customize_Control {
	
		private $fonts = false;
		public $l10n = array();
		
		// critical for JS constructor
		public $type = 'dynamicnews_pro_custom_font';
		
		public function __construct($manager, $id, $args = array(), $options = array()) {
		
			// Make Buttons translateable
			$this->l10n = array(
				'previous' =>	__( 'Previous Font', 'dynamicnews-pro' ),
				'next' =>		__( 'Next Font', 'dynamicnews-pro' ),
				'standard' =>	__( 'Default', 'dynamicnews-pro' )
			);
					
			// Get Theme Options
			$theme_options = dynamicnews_pro_theme_options();
			
			// Set Fonts
			$this->fonts = Dynamic_News_Pro_Custom_Font_Lists::get_fonts($theme_options['available_fonts']);
	
			parent::__construct( $manager, $id, $args );
			
		}
		
		public function enqueue() {

			// Register and Enqueue Custom Font JS Constructor
			wp_enqueue_script( 'dynamicnews-pro-custom-font-control', plugins_url('/js/custom-font-control.js', dirname(dirname(dirname(__FILE__)) )), array( 'customize-controls' ), '', true );
		
		}
		
		public function render_content() {
		
			$l10n = json_encode( $this->l10n );
			
			if( !empty($this->fonts) ) :
			
            ?>
                <label>
                    <span class="customize-control-title" data-l10n="<?php echo esc_attr( $l10n ); ?>" data-font="<?php echo esc_attr( $this->setting->default ); ?>">
						<?php echo esc_html( $this->label ); ?>
					</span>
					<div class="customize-font-select-control">
						<select <?php $this->link(); ?>>
							<?php
								foreach ( $this->fonts as $k => $v )
								{
									printf('<option value="%s" %s>%s</option>', $k, selected($this->value(), $k, false), $v);
								}
							?>
						</select>
					</div>
					<div class="actions"></div>
				</label>
                
            <?php
			endif;
		}
		
	}
	
endif;


?>