<?php
/**
 * Returns theme options
 *
 * Uses sane defaults in case the user has not configured any theme options yet.
 */


// Return theme options
function dynamicnews_pro_theme_options() {
    
	// Merge Theme Options Array from Database with Default Options Array
	$theme_options = wp_parse_args( 
		
		// Get saved theme options from WP database
		get_option( 'dynamicnews_theme_options', array() ), 
		
		// Merge with Default Options if setting was not saved yet
		dynamicnews_pro_default_options() 
		
	);

	// Return theme options
	return $theme_options;
	
}


// Build default options array
function dynamicnews_pro_default_options() {

	$default_options = array(
		'header_logo' 						=> '',
		'header_padding'					=> false,
		'footer_text'						=> '',
		'credit_link' 						=> true,
		'text_font' 						=> 'Droid Sans',
		'title_font' 						=> 'Francois One',
		'navi_font' 						=> 'Francois One',
		'widget_title_font' 				=> 'Droid Sans',
		'available_fonts'					=> 'favorites'
	);
	
	return $default_options;
}


?>