<?php
/*
 * Custom Logo
 * 
 * Removes default Site Logo of Dynamic News and replaces it with Site Logo Feature
 *
 */

// Remove default site title
remove_action( 'dynamicnews_site_title', 'dynamicnews_display_site_title' );

// Display Footer Widgets on Dynamic News
add_action( 'dynamicnews_site_title', 'dynamicnews_pro_display_site_logo' );

// Display Site Title
function dynamicnews_pro_display_site_logo() { 

	// Get Theme Options from Database
	$theme_options = dynamicnews_pro_theme_options();
?>

	<a href="<?php echo esc_url(home_url('/')); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
				
	<?php // Display Logo Image or Site Title
		if ( isset($theme_options['header_logo']) and $theme_options['header_logo'] <> '' ) : ?>
			<img class="site-logo" src="<?php echo esc_url($theme_options['header_logo']); ?>" alt="<?php esc_attr(bloginfo('name')); ?>" />
	<?php else: ?>
			<h1 class="site-title"><?php bloginfo('name'); ?></h1>
	<?php endif; ?>
	
	</a>

<?php
}


// Implement Header Padding Setting
add_action('wp_head', 'dynamicnews_pro_header_padding');

function dynamicnews_pro_header_padding() { 
	
	// Get Theme Options from Database
	$theme_options = dynamicnews_pro_theme_options();
	
	
	// Remove Header Padding
	if ( isset($theme_options['header_padding']) and $theme_options['header_padding'] == true ) :
	
		echo '<style type="text/css">
				@media only screen and (max-width: 60em) {
					#header-content { padding-top: 0; }
				}
				#header { padding: 0; }
		</style>';
	
	endif;
	
}


?>