<?php

// Replace default Google Fonts URL with custom Fonts
add_filter('dynamicnews_google_fonts_url', 'dynamicnews_pro_google_fonts_url');

function dynamicnews_pro_google_fonts_url() { 

	// Get Theme Options from Database
	$theme_options = dynamicnews_pro_theme_options();
	
	// Default Fonts which haven't to be load from Google
	$default_fonts = Dynamic_News_Pro_Custom_Font_Lists::default_browser_fonts();
	
	// Set Google Font Array
	$google_font_families = array();
	
	// Add Text Font
	if( isset($theme_options['text_font']) and !in_array($theme_options['text_font'], $default_fonts)) :
		
		$google_font_families[] = $theme_options['text_font'];
		$default_fonts[] = $theme_options['text_font']; 
		
	endif;
	
	// Add Title Font
	if( isset($theme_options['title_font']) and !in_array($theme_options['title_font'], $default_fonts)) :
		
		$google_font_families[] = $theme_options['title_font'];
		$default_fonts[] = $theme_options['title_font']; 
		
	endif;
	
	// Add Navigation Font
	if( isset($theme_options['navi_font']) and !in_array($theme_options['navi_font'], $default_fonts)) :
		
		$google_font_families[] = $theme_options['navi_font'];
		$default_fonts[] = $theme_options['navi_font'];
		
	endif;

	// Add Widget Title Font
	if( isset($theme_options['widget_title_font']) and !in_array($theme_options['widget_title_font'], $default_fonts)) :
		
		$google_font_families[] = $theme_options['widget_title_font'];
		$default_fonts[] = $theme_options['widget_title_font']; 
		
	endif;
	
	// Setup Google Font URLs
	$query_args = array(
		'family' => urlencode( implode( '|', $google_font_families ) ),
		'subset' => urlencode( 'latin,latin-ext' ),
    );
	$google_fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );
	
	return $google_fonts_url;
	
}


// Add new Custom CSS styles for custom fonts
add_action('wp_head', 'dynamicnews_pro_css_fonts');

function dynamicnews_pro_css_fonts() {
	
	// Get Theme Options from Database
	$theme_options = dynamicnews_pro_theme_options();
	
	// Get Default Fonts from settings
	$default_options = dynamicnews_pro_default_options();
	
	// Set Font CSS Variable
	$font_css = '';
	
	// Set Default Text Font
	if ( isset($theme_options['text_font']) and $theme_options['text_font'] <> 'Droid Sans' ) : 
	
		$font_css .= '
			body, input, textarea {
				font-family: "'.esc_attr($theme_options['text_font']).'";
			}';
		
	endif;
	
	// Set Title Font
	if ( isset($theme_options['title_font']) and $theme_options['title_font'] <> 'Francois One' ) : 
	
		$font_css .= '
			#logo .site-title, .page-title, .post-title, #frontpage-slider .zeeslide .slide-entry .slide-title,
			#comments .comments-title, #respond #reply-title {
				font-family: "'.esc_attr($theme_options['title_font']).'";
			}';
		
	endif;
	
	// Set Navigation Font
	if ( isset($theme_options['navi_font']) and $theme_options['navi_font'] <> 'Francois One' ) : 
	
		$font_css .= '
			#mainnav-icon, #mainnav-menu a {
				font-family: "'.esc_attr($theme_options['navi_font']).'";
			}';
		
	endif;
	
	// Set Widget Title Font
	if ( isset($theme_options['widget_title_font']) and $theme_options['widget_title_font'] <> 'Droid Sans' ) : 
	
		$font_css .= '
			.widgettitle, #frontpage-magazine-widgets .widget .widgettitle {
				font-family: "'.esc_attr($theme_options['widget_title_font']).'";
			}';
		
	endif;
	
	// Print Font CSS
	if ( isset($font_css) and $font_css <> '' ) :
	
		echo '<style type="text/css">';
		echo $font_css;
		echo '</style>';
	
	endif;
}

?>