<?php
/***
 * Theme Info
 *
 * Adds a simple Theme Info page to the Appearance section of the WordPress Dashboard. 
 *
 */


// Remove default Theme Info Page
remove_action('admin_menu', 'dynamicnews_add_theme_info_page');

// Add Dynamic News Pro Theme Info page to admin menu
add_action('admin_menu', 'dynamicnews_pro_add_theme_info_page');

function dynamicnews_pro_add_theme_info_page() {
	
	add_theme_page( 
		__('Welcome to Dynamic News', 'dynamicnews-pro'), 
		__('Theme Info', 'dynamicnews-pro'), 
		'manage_options', 
		'dynamicnews', 
		'dynamicnews_pro_display_theme_info_page'
	);
	
}


// Display Theme Info page
function dynamicnews_pro_display_theme_info_page() { 
	
	// Get Theme Details from style.css
	$theme_data = wp_get_theme(); 
	
	// Get Theme Options from Database
	$theme_options = dynamicnews_pro_theme_options();

	// Get License Data
	$license = trim( get_option( 'dynamicnews_pro_license_key' ) );
	$status = isset($theme_options['license_status']) ? $theme_options['license_status'] : false;

?>
			
	<div class="wrap theme-info-wrap">

		<h1><?php printf( __( 'Welcome to Dynamic News Pro %s', 'dynamicnews-pro' ), $theme_data->Version ); ?></h1>

		<div class="theme-description"><?php echo $theme_data->Description; ?></div>
		
		<hr>
		<div class="important-links clearfix">
			<p><strong><?php _e('Important Links:', 'dynamicnews-pro'); ?></strong>
				<a href="http://themezee.com/themes/dynamicnews/" target="_blank"><?php _e('Theme Info Page', 'dynamicnews-pro'); ?></a>
				<a href="<?php echo get_template_directory_uri(); ?>/changelog.txt" target="_blank"><?php _e('Changelog', 'dynamicnews-pro'); ?></a>
				<a href="http://preview.themezee.com/dynamicnews/" target="_blank"><?php _e('Theme Demo', 'dynamicnews-pro'); ?></a>
				<a href="http://themezee.com/docs/dynamicnews-documentation/" target="_blank"><?php _e('Theme Documentation', 'dynamicnews-pro'); ?></a>
				<a href="http://wordpress.org/support/view/theme-reviews/dynamicnews-lite?filter=5" target="_blank"><?php _e('Rate this theme', 'dynamicnews-pro'); ?></a>
				
				<span class="social-icons">
					<a href="http://themezee.com/newsletter/" target="_blank"><span class="genericon-mail"></span></a>
					<a href="https://www.facebook.com/ThemeZee" target="_blank"><span class="genericon-facebook"></span></a>
					<a href="https://twitter.com/ThemeZee" target="_blank"><span class="genericon-twitter"></a>
				</span>
			</p>
		</div>
		<hr>
				
		<div id="getting-started">
		
			<h3><?php _e( 'Getting Started with Dynamic News Pro', 'dynamicnews-pro' ); ?></h3>
			
			<div class="columns-wrapper clearfix">

				<div class="column column-half clearfix">
						
					<div class="section">
						<h4><?php _e( 'Theme Documentation', 'dynamicnews-pro' ); ?></h4>
						
						<p class="about"><?php _e( 'Need any help to setup and configure this theme? We got you covered with an extensive theme documentation on our website.', 'dynamicnews-pro' ); ?></p>
						<p>
							<a href="http://themezee.com/docs/dynamicnews-documentation/" target="_blank" class="button button-secondary"><?php _e('Visit Dynamic News Documentation', 'dynamicnews-pro'); ?></a>
						</p>
					</div>
					
					<div class="section">
						<h4><?php _e( 'Theme Options', 'dynamicnews-pro' ); ?></h4>
						
						<p class="about"><?php _e( 'Dynamic News supports the awesome Theme Customizer for all theme settings. Click "Customize Theme" to open the Customizer now.', 'dynamicnews-pro' ); ?></p>
						<p>
							<a href="<?php echo admin_url( 'customize.php' ); ?>" class="button button-secondary"><?php _e('Customize Theme', 'dynamicnews-pro'); ?></a>
						</p>
					</div>
					
					<div class="section">
						<h4><?php _e( 'PRO Version License', 'dynamicnews-pro' ); ?></h4>
						
						<form method="post" action="options.php">
		
							<?php settings_fields('dynamicnews_pro_license'); ?>
							
							<table class="form-table">
								<tbody>
									<tr valign="top">	
										<th scope="row" valign="top">
											<?php _e('License Key', 'dynamicnews-pro'); ?>
										</th>
										<td>
											<input id="dynamicnews_pro_license_key" name="dynamicnews_pro_license_key" type="text" class="regular-text" value="<?php esc_attr_e( $license ); ?>" />
											<label class="description" for="dynamicnews_pro_license_key"><?php _e('Enter your license key', 'dynamicnews-pro'); ?></label>
										</td>
									</tr>
									<?php if( $license !== false && $license <> '' ) : ?>
										
										<tr valign="top">	
											<th scope="row" valign="top">
												<?php _e('Activate License', 'dynamicnews-pro'); ?>
											</th>
											<td>
												<?php 
												// Display Invalid License Notice
												if( isset( $_GET['settings-updated'] ) && $status !== false && $status == 'invalid' ) : ?>
												
													<span class="invalid-license"><?php _e('Invalid License Key', 'dynamicnews-pro'); ?></span>
													
												<?php endif;

												// Display Active License Notice
												if( $status !== false && $status == 'valid' ) :
													wp_nonce_field( 'dynamicnews_pro_nonce', 'dynamicnews_pro_nonce' ); ?>
													
													<span class="active-license"><?php _e('Active', 'dynamicnews-pro'); ?></span>
													<input type="submit" class="button-secondary" name="dynamicnews_pro_license_deactivate" value="<?php _e('Deactivate License', 'dynamicnews-pro'); ?>"/>
												
												<?php else :
													wp_nonce_field( 'dynamicnews_pro_nonce', 'dynamicnews_pro_nonce' ); ?>
													
													<input type="submit" class="button-secondary" name="dynamicnews_pro_license_activate" value="<?php _e('Activate License', 'dynamicnews-pro'); ?>"/>
												
												<?php endif; ?>

											</td>
										</tr>
										
									<?php endif; ?>
									
									
								</tbody>
							</table>	
							<?php submit_button(); ?>
						
						</form>
						
					</div>

				</div>
				
				<div class="column column-half clearfix">
					
					<img src="<?php echo get_template_directory_uri(); ?>/screenshot.png" />
					
				</div>
				
			</div>
			
		</div>
		
		<hr>
		
		<div id="theme-author">
			
			<p><?php printf( __( 'Dynamic News is proudly brought to you by %1s. If you like this theme, %2s :) ', 'dynamicnews-pro' ), 
				'<a target="_blank" href="http://themezee.com" title="ThemeZee">ThemeZee</a>',
				'<a target="_blank" href="http://wordpress.org/support/view/theme-reviews/dynamicnews-lite?filter=5" title="Dynamic News Lite Review">' . __( 'rate it', 'dynamicnews-pro' ) . '</a>'); ?>
			</p>
		
		</div>
	
	</div>

<?php
}


// Register Dynamic News Pro License Settings
add_action('admin_init', 'dynamicnews_pro_register_option');

function dynamicnews_pro_register_option() {
	// creates our settings in the options table
	register_setting('dynamicnews_pro_license', 'dynamicnews_pro_license_key', 'dynamicnews_pro_sanitize_license' );
}


function dynamicnews_pro_sanitize_license( $new ) {
	
	$old = get_option( 'dynamicnews_pro_license_key' );
	
	// Delete License Status if new license is entered
	if( $old && $old != $new ) :
		
		// Get Theme Options from Database
		$theme_options = dynamicnews_pro_theme_options();
		
		// new license has been entered, so must reactivate
		$theme_options['license_status'] = false;
			
		// Update Theme Options
		update_option( 'dynamicnews_theme_options', $theme_options );
		
	endif;
	
	return esc_attr($new);
}


// Activate License Key
add_action('admin_init', 'dynamicnews_pro_activate_license');

function dynamicnews_pro_activate_license() {

	// listen for our activate button to be clicked
	if( isset( $_POST['dynamicnews_pro_license_activate'] ) ) {
	
		// run a quick security check 
	 	if( ! check_admin_referer( 'dynamicnews_pro_nonce', 'dynamicnews_pro_nonce' ) ) 	
			return; // get out if we didn't click the Activate button
			
		// Get Theme Options from Database
		$theme_options = dynamicnews_pro_theme_options();

		// retrieve the license from the database
		$license = trim( get_option( 'dynamicnews_pro_license_key' ) );
			

		// data to send in our API request
		$api_params = array( 
			'edd_action' => 'activate_license', 
			'license' 	=> $license, 
			'item_name' => urlencode( DYNAMICNEWS_PRO_NAME ), // the name of our product in EDD
			'url'       => home_url()
		);
		
		// Call the custom API.
		$response = wp_remote_get( add_query_arg( $api_params, 'http://themezee.com' ), array( 'timeout' => 15, 'sslverify' => false ) );

		// make sure the response came back okay
		if ( is_wp_error( $response ) )
			return false;

		// decode the license data
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		
		// $license_data->license will be either "valid" or "invalid"
		$theme_options['license_status'] = $license_data->license;
		
		// Update Theme Options
		update_option( 'dynamicnews_theme_options', $theme_options );

	}
}


// Deactivate License Key
add_action('admin_init', 'dynamicnews_pro_deactivate_license');

function dynamicnews_pro_deactivate_license() {

	// listen for our activate button to be clicked
	if( isset( $_POST['dynamicnews_pro_license_deactivate'] ) ) {

		// run a quick security check 
	 	if( ! check_admin_referer( 'dynamicnews_pro_nonce', 'dynamicnews_pro_nonce' ) ) 	
			return; // get out if we didn't click the Activate button
		
		// Get Theme Options from Database
		$theme_options = dynamicnews_pro_theme_options();
		
		// retrieve the license from the database
		$license = trim( get_option( 'dynamicnews_pro_license_key' ) );
			

		// data to send in our API request
		$api_params = array( 
			'edd_action'=> 'deactivate_license', 
			'license' 	=> $license, 
			'item_name' => urlencode( DYNAMICNEWS_PRO_NAME ), // the name of our product in EDD
			'url'       => home_url()
		);
		
		// Call the custom API.
		$response = wp_remote_get( add_query_arg( $api_params, 'http://themezee.com' ), array( 'timeout' => 15, 'sslverify' => false ) );

		// make sure the response came back okay
		if ( is_wp_error( $response ) )
			return false;

		// decode the license data
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		
		// $license_data->license will be either "deactivated" or "failed"
		if( $license_data->license == 'deactivated' )
			$theme_options['license_status'] = false;
			
		// Update Theme Options
		update_option( 'dynamicnews_theme_options', $theme_options );

	}
}


// Check for License Status
function dynamicnews_pro_check_license() {

	global $wp_version;

	$license = trim( get_option( 'dynamicnews_pro_license_key' ) );
		
	$api_params = array( 
		'edd_action' => 'check_license', 
		'license' => $license, 
		'item_name' => urlencode( DYNAMICNEWS_PRO_NAME ),
		'url'       => home_url()
	);

	// Call the custom API.
	$response = wp_remote_get( add_query_arg( $api_params, 'http://themezee.com' ), array( 'timeout' => 15, 'sslverify' => false ) );


	if ( is_wp_error( $response ) )
		return false;

	$license_data = json_decode( wp_remote_retrieve_body( $response ) );

	if( $license_data->license == 'valid' ) {
		echo 'valid'; exit;
		// this license is still valid
	} else {
		echo 'invalid'; exit;
		// this license is no longer valid
	}
}


// Add CSS for Theme Info Panel
remove_action('admin_enqueue_scripts', 'dynamicnews_theme_info_page_css');
add_action('admin_enqueue_scripts', 'dynamicnews_pro_theme_info_page_css');

function dynamicnews_pro_theme_info_page_css($hook) { 

	// Load styles and scripts only on theme info page
	if ( 'appearance_page_dynamicnews' != $hook ) {
		return;
	}
	
	// Embed theme info css style
	wp_enqueue_style( 'dynamicnews-pro-theme-info-css', plugins_url('/css/theme-info.css', dirname(dirname(__FILE__)) ), array(), DYNAMICNEWS_PRO_VERSION );

}


?>