<?php
/*
Plugin Name: Dynamic News Pro
Plugin URI: http://themezee.com/themes/dynamicnews/#PROVersion-1
Description: Adds additional features like footer widgets, custom colors, fonts and logo upload to the Dynamic News Lite theme.
Author: ThemeZee
Author URI: http://themezee.com/
Version: 1.0
Text Domain: dynamicnews-pro
Domain Path: /languages/
License: GPL v3
License URI: http://www.gnu.org/licenses/gpl-3.0.html

Dynamic News Pro Plugin
Copyright(C) 2015, ThemeZee.com - support@themezee.com

*/

// Define Plugin Name
define( 'DYNAMICNEWS_PRO_NAME', 'Dynamic News Pro');

// Define Version Number
define( 'DYNAMICNEWS_PRO_VERSION', '1.0' );


// Setup Plugin
add_action( 'init', 'dynamicnews_pro_setup' );

function dynamicnews_pro_setup() {

	$theme_support = get_theme_support( 'dynamicnews-pro' );

	// Return early if Dynamic News Theme is not active
	if ( ! $theme_support ) {
		return;
	}

	// include Theme Info Admin Options
	require( dirname( __FILE__ ) . '/inc/admin/theme-info.php' );
	
	// include Theme Customizer Options
	require( dirname( __FILE__ ) . '/inc/customizer/customizer.php' );
	require( dirname( __FILE__ ) . '/inc/customizer/default-options.php' );
	
	// include Custom Colors, Fonts and Logo Files
	require( dirname( __FILE__ ) . '/inc/custom-colors.php' );
	require( dirname( __FILE__ ) . '/inc/custom-fonts.php' );
	require( dirname( __FILE__ ) . '/inc/custom-logo.php' );
	
	// Include Footer Files
	require( dirname( __FILE__ ) . '/inc/footer-widgets.php' );
	require( dirname( __FILE__ ) . '/inc/footer-text.php' );
	
	// Add Translation
	load_plugin_textdomain( 'dynamicnews-pro', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

}


// Load Dynamic News Pro Stylesheet
add_action('wp_enqueue_scripts', 'dynamicnews_pro_enqueue_scripts');

function dynamicnews_pro_enqueue_scripts() {

	// Register and Enqueue Stylesheet
	wp_enqueue_style('dynamicnews-pro-stylesheet', plugins_url('/css/dynamicnews-pro.css', __FILE__), array('dynamicnewslite-stylesheet'), DYNAMICNEWS_PRO_VERSION);

}


// Register Widgets
add_action( 'widgets_init', 'dynamicnews_pro_register_widgets', 20 );

function dynamicnews_pro_register_widgets() {

	$theme_support = get_theme_support( 'dynamicnews-pro' );

	// Return early if Dynamic News Theme is not active
	if ( ! $theme_support ) {
		return;
	}
	
	//Register Footer Widgets
	register_sidebar( array(
		'name' => __( 'Footer Left', 'dynamicnews-pro' ),
		'id' => 'footer-left',
		'description' => __( 'Appears on footer on the left hand side.', 'dynamicnews-pro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widgettitle"><span>',
		'after_title' => '</span></h3>'
	));
	register_sidebar( array(
		'name' => __( 'Footer Center Left', 'dynamicnews-pro' ),
		'id' => 'footer-center-left',
		'description' => __( 'Appears on footer on center left position.', 'dynamicnews-pro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widgettitle"><span>',
		'after_title' => '</span></h3>'
	));
	register_sidebar( array(
		'name' => __( 'Footer Center Right', 'dynamicnews-pro' ),
		'id' => 'footer-center-right',
		'description' => __( 'Appears on footer on center right position.', 'dynamicnews-pro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widgettitle"><span>',
		'after_title' => '</span></h3>'
	));
	register_sidebar( array(
		'name' => __( 'Footer Right', 'dynamicnews-pro' ),
		'id' => 'footer-right',
		'description' => __( 'Appears on footer on the right hand side.', 'dynamicnews-pro' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h3 class="widgettitle"><span>',
		'after_title' => '</span></h3>'
	));
}


// Add Admin Notices
add_action( 'admin_notices', 'dynamicnews_pro_admin_notice' );

function dynamicnews_pro_admin_notice() {
	
	global $pagenow;
	
	// Disply only on Plugins and Themes page
    if ( ( $pagenow == 'themes.php' && !isset($_GET['page']) ) or $pagenow == 'plugins.php' ) :
	
		// Display Notice if Dynamic News theme is not active
		if ( ! get_theme_support( 'dynamicnews-pro' )) : ?>
			<div class="error">
				<p><?php _e( 'The Dynamic News Pro Plugin needs the Dynamic News Lite Theme (Version 1.1.2 or higher) activated in order to work. You should deactivate Dynamic News Pro if you have switched to another theme permanently.', 'dynamicnews-pro' ); ?></p>
			</div>
		<?php
		else: 
		
			// Display Notice if no license was entered yet
			$license = get_option( 'dynamicnews_pro_license_key' );
			
			if( $license == false or $license == '' ) : ?>
				<div class="updated">
					<p><?php printf( __( 'Please enter your license key for Dynamic News Pro in order to receive updates and support. <a href="%s">Enter License Key</a>', 'dynamicnews-pro' ), admin_url( 'themes.php?page=dynamicnews' ) ); ?></p>
				</div>
			
			<?php
			endif;
		
		endif;
		
	endif;
}


// Include Plugin Updater class
require( dirname( __FILE__ ) . '/inc/admin/Dynamic_News_Pro_Plugin_Updater.php' );

// Add automatic plugin updater from ThemeZee Store API
add_action( 'admin_init', 'dynamicnews_pro_plugin_updater', 0 );

function dynamicnews_pro_plugin_updater() {

	// retrieve our license key from the DB
	$license_key = trim( get_option( 'dynamicnews_pro_license_key' ) );

	// setup the updater
	$dynamicnews_pro_updater = new Dynamic_News_Pro_Plugin_Updater( 'http://themezee.com', __FILE__, array( 
			'version' 	=> DYNAMICNEWS_PRO_VERSION, // current version number
			'license' 	=> $license_key, 		 // license key
			'item_name' => DYNAMICNEWS_PRO_NAME, 	 // name of this plugin
			'author' 	=> 'ThemeZee'  			 // author of this plugin
		)
	);

}

?>