<?php

$DatabaseLogin = array(
  'DBfirst' => array(
    'DatabaseType' => 'mysql',
    'Hostname' => 'localhost',
    'DatabaseName' => 'webdevfl_cdata',
    'Username' => 'webdevfl_cdata',
    'Password' => 'theu621UM6hW1Oz',
  )
);

global $dbh;

ini_set('mysql.connect_timeout', 15);
ini_set('default_socket_timeout', 15);

include('/home/webdevfluffyduck/www/cdata/class.phpmailer.php');

function DatabaseConnection ( $Database = "DBfirst" ) {

  global $DatabaseLogin;
  global $dbh;

  try {
    $dbh = new PDO('mysql:host='.$DatabaseLogin[$Database]['Hostname'].';dbname='.$DatabaseLogin[$Database]['DatabaseName'], $DatabaseLogin[$Database]['Username'],$DatabaseLogin[$Database]['Password']);
    $dbh->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    return 1;
  } catch(Exception $e) {
        echo date('Y-m-d H:i:s').' - Error: '.$e->getMessage();
    return 0;
  }

}

DatabaseConnection();

function get_google_creds($account,$type) {

global $dbh;

	$sql = $dbh->prepare("/* GC - Get Creds */ SELECT * FROM Googleconnect WHERE account = :account AND type = :type");
	$result = $sql->execute(array(
		':account' => $account,
		':type' => $type
	)) OR die(print_r($sql->errorInfo(),true));

	if($sql->rowcount() > 0) {

		while($ar = $sql->fetch($result,PDO::FETCH_ASSOC)) {
			$clientid = $ar['clientid'];
			$clientsecret = $ar['clientsecret'];
			$token = $ar['token'];
			$refreshtoken = $ar['refreshtoken'];
			$created = $ar['created'];
		}

	}

	return array($clientid,$clientsecret,$token,$refreshtoken,$created);
}

function retrieve_enabled_activeuser_sites() {

global $dbh;

	$sql = $dbh->prepare("/* GC - Get ActiveUser Sites */ SELECT viewID FROM Webproperty WHERE recordactiveUsers = :state");
	$result = $sql->execute(array(
		':state' => 'Y'
	)) OR die(print_r($sql->errorInfo(),true));

	if($sql->rowCount() > 0) {

		$viewIDs = array();

		while($ar = $sql->fetch($result,PDO::FETCH_ASSOC)) {
			$viewIDs[] = $ar['viewID'];	
		}

	}

	return $viewIDs;
}

function get_analytic_site_credentials($webpropertyID) {

global $dbh;

	$sql = $dbh->prepare("/* GC - GEt All Analytic Info */ SELECT wp.viewID,gc.clientID,gc.clientsecret,gc.token,gc.refreshtoken,gc.created FROM Webproperty AS wp LEFT JOIN Googleconnect AS gc ON wp.gcID = gc.gcID WHERE wp.wpID = :webpropID");
        $result = $sql->execute(array(
                ':webpropID' => $webpropertyID
        )) OR die(print_r($sql->errorInfo(),true));

        if($sql->rowCount() > 0) {

                while($ar = $sql->fetch($result,PDO::FETCH_ASSOC)) {
                        $viewID = $ar['viewID'];
                        $clientid = $ar['clientID'];
                        $clientsecret = $ar['clientsecret'];
                        $token = $ar['token'];
                        $refreshtoken = $ar['refreshtoken'];
                        $created = $ar['created'];
                }

        } 

        return array($clientid,$clientsecret,$token,$refreshtoken,$created,$viewID);
}
/**
	Record activeusers for sites that have activeUserrecording enabled 
**/
function record_activeusers($viewID,$users) {

global $dbh;

	$sql = $dbh->prepare("/* GC - Record ActiveUsers */ INSERT INTO Activeusers (viewID,activeusers) VALUES (:viewID,:users)");
	$sqldata = array(
		':viewID' => $viewID,
		':users' => $users
	);

	try {
		$sql->execute($sqldata);
	} catch(PDOException $x) {
		mail("mario@fluffyduck.com.au","Carrion - ActiveUser Record","SQL ERROR RECORDING\n\n".$x->getMessage());
		exit;
	}

	if($sql->rowCount() > 0) {
		// do nothing
	} else {
		mail("mario@fluffyduck.com.au","Carrion - ACtiveUser Record","Insert ActiveUsers Error");
	}
		
}

/**
	Record activeusers VS URLS being accessed at that time
**/
function record_activeusersURLs($viewID,$patharr) {

global $dbh;

	for($x=0; $x<count($patharr['path']); $x++) {

		$sql = $dbh->prepare("/* GC - Record ActiveUsersURLs */ INSERT INTO Activeusers_urls (viewID,path,activeusers) VALUES (:viewID,:path,:users)");
		$sqldata = array(
			':viewID' => $viewID,
			':path' => $patharr['path'][$x],
			':users' => $patharr['users'][$x]
		);

		try {
			$sql->execute($sqldata);
		} catch(PDOException $x) {
			mail("mario@fluffyduck.com.au","Carrion - ActiveUser URL Record","SQL Error Recording\n\n".$x->getMessage());
			exit;
		}

		if($sql->rowCount() > 0) {
			// do nothing
		} else {
			mail("mario@fluffyduck.com.au","Carrion - ActiveUser URL Record","Insert ActiveUsers URL Error");
		}
	}
}

/**
	function :: get threshold limits
**/
function threshold_getlimits($viewID) {

global $dbh;

	$sql = $dbh->prepare("/* GC - Get Threshold Limits */ SELECT low,medium,high,critical,onlineavg FROM Webproperty_thresholds WHERE viewID = :viewID");
	$sqldata = array(
		':viewID' => $viewID
	);

	try {
		$result = $sql->execute($sqldata);
	} catch(PDOException $x) {
		mail("mario@fluffyduck.com.au","Carrion - Get Limits","Get Limit Error ViewID [$viewID]\n\n".$x->getMessage());
		exit;
	}

	if($sql->rowcount() > 0) {

                while($ar = $sql->fetch($result,PDO::FETCH_ASSOC)) {
			$low_limit = $ar['low'];
			$medium_limit = $ar['medium'];
			$high_limit = $ar['high'];
			$critical_limit = $ar['critical'];
			$online_avg = $ar['onlineavg'];
		}
		$defaultretrieve = FALSE;

	} else {

		// No records found - retrieve default
		$defaultretrieve = TRUE;

	}

	if(!$defaultretrieve) {
		return array($low_limit,$medium_limit,$high_limit,$critical_limit,$online_avg);
	} else {
		return array('999','999','999','999','999');
	}
}

/**
	function :: get previous activeusers to check threshold
**/
function get_previous_activeusers($viewID) {

global $dbh;

	$sql = $dbh->prepare("/* GC - get prev activeusers */ SELECT activeusers,inserted FROM Activeusers WHERE viewID = :viewID ORDER BY inserted DESC limit 6");
	$sqldata = array(
		':viewID' => $viewID
	);

	try {
		$result = $sql->execute($sqldata);
	} catch(PDOException $x) {
		mail("mario@fluffyduck.com.au","Carrion - Get Prev ActiveUsers","Error Getting Prev Users ViewID [$viewID]\n\n".$x->getMessage());
		exit;
	}

	if($sql->rowCount() > 0) {
		
		$activeusers = array();
		$inserted = array();

		while($ar = $sql->fetch($result,PDO::FETCH_ASSOC)) {

			$activeusers[] = $ar['activeusers'];
			$inserted[] = $ar['inserted'];			

		}
	}

	return array($activeusers,$inserted);
}

/**
	function :: threshold monitoring of activeUsers
**/
function threshold_monitoring($viewID) {

global $dbh;

	// Get Threshold Limits
	list($low_limit,$medium_limit,$high_limit,$critical_limit,$online_avg) = threshold_getlimits($viewID);	

	// Verify threshold limit retrieval, if it failed limits = 999 then retrieve defaults
	if($low_limit == "999" && $medium_limit == "999" && $high_limit == "999" && $critical_limit == "999" && $online_avg == "999") {
		// specific retrieval failed -> retrieve defaults
		list($low_limit,$medium_limit,$high_limit,$critical_limit,$online_avg) = threshold_getlimits('999');
	}

	// get previous activeusers (array responses)
	list($activeusers,$inserted) = get_previous_activeusers($viewID);
	
	if($activeusers[0] > $online_avg) {
		// active users is higher than the average -> do nothing
		break;
	} else {

		// activeusers is less than the specified online average and/or default average -> SHOW TIME
		
		// we need to check each threshold level to see which passes and which doesnt
		// check low limit
		$limitcheck = ($activeusers[0] / $online_avg) * 100;

		if($limitcheck < $low_limit) {
			// FAILED onto next check
			$lowcheck_msg = "FAIL";
		} else {
			$lowcheck_msg = "OK";
		}

		if($limitcheck < $medium_limit) {
			// FAILED 
			$mediumcheck_msg = "FAIL";
		} else {
			$mediumcheck_msg = "OK";
		}

		if($limitcheck < $high_limit) {
			// FAILED
			$highcheck_msg = "FAIL";
		} else {
			$highcheck_msg = "OK";
		}

		if($limitcheck < $critical_limit) {
			// FAILED
			$criticalcheck_msg = "FAIL";
		} else {
			$criticalcheck_msg = "OK";
		}

		// if any checks FAILED -> we need to send a notification out
		if($lowcheck_msg == "FAIL" || $mediumcheck_msg == "FAIL" || $highcheck_msg == "FAIL" || $criticalcheck_msg == "FAIL") {

			threshold_notification($viewID,$activeusers,$inserted,$online_avg,$low_limit,$medium_limit,$high_limit,$critical_limit,$lowcheck_msg,$mediumcheck_msg,$highcheck_msg,$criticalcheck_msg);

		}
	}
}

/**
	function :: threshold notification
**/
function threshold_notification($viewID,$activeusers,$inserted,$online_avg,$low_limit,$medium_limit,$high_limit,$critical_limit,$lowcheck_msg,$mediumcheck_msg,$highcheck_msg,$criticalcheck_msg) {

	// Retrieve site plain name
	$sitename = get_property_name($viewID);

	if($lowcheck_msg == "FAIL") {
		$currentwarning = "Low";
	}
	if($mediumcheck_msg == "FAIL") {
		$currentwarning = "Medium";
	}
	if($highcheck_msg == "FAIL") {
		$currentwarning = "High";
	}
	if($criticalcheck_msg == "FAIL") {
		$currentwarning = "CRITICAL";
	}

	// Build Notification Mail Body
$mailbody = '<b>ACTIVE USER ALERT<B><br><br>
This email is only received if the current active users is lower than one of the trigger levels.<br><br>
Site Name : '.$sitename.'<br><br>
<table>
<tr><td>Online Avg Target</td><td align="right">'.$online_avg.'</td></tr>
<tr><td>Current Online</td><td align="right">'.$activeusers[0].'</td></tr>
<tr><td colspan="2">&nbsp;</td></tr>
<tr><td>Warning Level</td><td align="center">'.$currentwarning.'</td></tr>
<tr><td colspan="2">&nbsp;</td></tr>
<tr><td colspan="2">&nbsp;</td></tr>
</table>
';

$mailbody .= '<table><tr><td colspan="2"><b>Previous ActiveUser Sample History</b></td></tr>';
$mailbody .= '<tr><td>Timestamp</td><td>Active Users</td></tr>';

	for($x=0; $x<count($activeusers); $x++) {

	$mailbody .= '<tr><td>'.$inserted[$x].'</td><td align="right">'.$activeusers[$x].'</td></tr>';

	}

$mailbody .= '</table>';

	$mail = new PHPMailer();
	$mail->IsMail();

	$mail->From="noreply@fluffyduck.com.au";
	$mail->FromName="Fluffy Mon";
	$mail->Sender="noreply@fluffyduck.com.au";
	
	$mail->AddAddress("mario@fluffyduck.com.au");
	$mail->AddAddress("mark@streetfx.com.au");
	$mail->AddCC("marioz@gmail.com");
	$mail->Subject = "Carrion - Active User Threshold Notification";

	$mail->IsHTML(true);

	$mail->Body = $mailbody;

	$mail->Send();

}

/**
	function :: get property name
**/
function get_property_name($viewID) {

global $dbh;

	$sql = $dbh->prepare("/* GC - get property name*/ SELECT webname FROM Webproperty WHERE viewID = :viewID");
	$sqldata = array(
		':viewID' => $viewID
	);

	try {
		$result = $sql->execute($sqldata);
	} catch(PDOException $x) {
		mail("mario@fluffyduck.com.au","Carrion - get name","Error getting property name viewID [$viewID]\n\n".$x->getMessage());
		exit;
	}

	if($sql->rowCount() > 0) {
		
		while($ar = $sql->fetch($result,PDO::FETCH_ASSOC)) {
			$sitename = $ar['webname'];
		}
	}

	return $sitename;
}

?>
