<?php
require_once 'google-api-php-client/src/Google/autoload.php';

session_start();

$client = new Google_Client();
$client->setAuthConfigFile('client_secrets.json');
$client->setRedirectUri('http://' . $_SERVER['HTTP_HOST'] . '/cdata/adsense/oauth2callback.php');
    $client->setScopes(array('https://www.googleapis.com/auth/adsense'));
    $client->setScopes(array('https://www.googleapis.com/auth/adsense.readonly'));
#    $client->setScopes(array('https://www.googleapis.com/auth/analytics'));
#    $client->setScopes(array('https://www.googleapis.com/auth/analytics.readonly'));
    $client->setAccessType('offline');   // Gets us our refreshtoken
    $client->setApprovalPrompt('force');

if (! isset($_GET['code'])) {
  $auth_url = $client->createAuthUrl();
  header('Location: ' . filter_var($auth_url, FILTER_SANITIZE_URL));
} else {
  $client->authenticate($_GET['code']);
  $_SESSION['access_token'] = $client->getAccessToken();
  $redirect_uri = 'http://' . $_SERVER['HTTP_HOST'] . '/cdata/adsense/';
  header('Location: ' . filter_var($redirect_uri, FILTER_SANITIZE_URL));
}
