<?php

/**

	Adsense Reporting Tool

	- Record PAGE RPM + Earnings per site
	- Record TODAY SO FAR estimated total as well
	- Script to run every 5mins

**/

include('functions-adsense.php');

// Retrieve list of active adsense accounts for processing
$adsenseaccounts = get_google_active_adsense_accounts();

for($x=0; $x<count($adsenseaccounts); $x++) {

	// We need to loop through each adsense account thats active and retrieve the rpm / estimated earnings for each and record that data
	list($client_id,$client_secret,$token,$refreshtoken,$created,$gcID,$adsenseAccount) = get_google_adsense_creds($adsenseaccounts[$x],'adsense');

	require_once 'google-api-php-client/src/Google/autoload.php';
#	session_start();

	$client = new Google_Client();
        $client->setClientId($client_id);
        $client->setClientSecret($client_secret);
        $client->setRedirectUri($redirect_uri);
        $client->setScopes(array('https://www.googleapis.com/auth/adsense'));
        $client->setScopes(array('https://www.googleapis.com/auth/adsense.readonly'));
        $client->setAccessType('offline');   // Gets us our refreshtoken
        $client->setApprovalPrompt('force');

        // Check if token has expired or not
        if($client->isAccessTokenExpired()) {

                // if yes we need to update token with the refreshtoken var
                $client->refreshToken($refreshtoken);
                $newtoken = $client->getAccessToken();
#               print_r($newtoken);
#               echo '<br>Refreshed<br>';

        } else {

                // if token hasnt expired use previous token
                $client->setAccessToken($token);

        }


        $service = new Google_Service_AdSense($client);

	// Report will be based on todays date (need to put it into adsense billing timezone (19 hours behind sydney time (daylight savings))
	$startDate = date('Y-m-d', strtotime("-19 hours"));
	$endDate = date('Y-m-d', strtotime("-19 hours")); 

    $optParams = array(
      'metric' => array(
        'PAGE_VIEWS_RPM', 'EARNINGS'),
      'dimension' => 'DOMAIN_NAME'
#      'sort' => '+DATE'
#      'filter' => array(
#        'AD_CLIENT_ID==' . $adClientId
#      )
    );

/*
    $optParams = array(
      'metric' => array(
        'EARNINGS')
#      'dimension' => 'DOMAIN_NAME'
#      'sort' => '+DATE'
#      'filter' => array(
#        'AD_CLIENT_ID==' . $adClientId
#      )
    );
*/

    // Run report.
    $report = $service->accounts_reports->generate($adsenseAccount, $startDate,
        $endDate, $optParams);

#var_dump($report);

    if (isset($report) && isset($report['rows'])) {

	// Attempt to retrieve currency metric from the headers
	// Page views RPm Currency
	if($report['headers'][1]['name'] == "PAGE_VIEWS_RPM" && $report['headers'][1]['type'] == "METRIC_CURRENCY") {
		$pageviewsrpm_currency = $report['headers'][1]['currency'];
	}

	// Estimated Earnings Currency
	if($report['headers'][2]['name'] == "EARNINGS" && $report['headers'][2]['type'] == "METRIC_CURRENCY") {
		$estimatedearnings_currency = $report['headers'][2]['currency'];
	}

	// Process each row of data for each domain
	for($y=0; $y<$report['totalMatchedRows']; $y++) {

		$domain = $report['rows'][$y][0];
		$pagerpm = $report['rows'][$y][1];
		$estimatedearnings = $report['rows'][$y][2];

#		echo "Account:".$adsenseaccounts[$x].",Domain:$domain,RPM:$pagerpm [$pageviewsrpm_currency],EstimatedEarnings:$estimatedearnings [$estimatedearnings_currency]<br>";
		adsense_record_pagerpm_earnings($domain,$pagerpm,$pageviewsrpm_currency,$estimatedearnings,$estimatedearnings_currency,$adsenseaccounts[$x]);

	}

#		echo "Today Est Earnings : $".$report['totals'][2]."<br>";
		adsense_record_todayest($adsenseaccounts[$x],$report['totals'][2]);
		
      // Display headers.
    } else {
      print "No rows returned.\n";
    }

}
