<?php

/**

	File to record adsense reports across accounts

	- yesterday
	- last 7 days
	- last 30 days

	- Script to run every 6 hours
**/


include('functions-adsense.php');

function adsense_get_earnings($adsenseAccount,$startDate,$endDate,$googleaccount,$lookuptype) {
         
global $service;

        $optParams = array(
         'metric' => array(
          'EARNINGS')
        );
        
        $report = $service->accounts_reports->generate($adsenseAccount,$startDate,$endDate,$optParams);

    if (isset($report) && isset($report['rows'])) {

        for($y=0; $y<$report['totalMatchedRows']; $y++) {
#		echo "Start : ".$startDate.", End : ".$endDate."<br>";
#                echo "$lookuptype Estimated Earnings - Account:".$adsenseAccount.", Earnings : ".$report['rows'][$y][0]."<br>";
		$amount = $report['rows'][$y][0];
        }
    } else {
		$amount = '0.00';
    }

return $amount;
    
}   

// Retrieve list of active adsense accounts for processing
$adsenseaccounts = get_google_active_adsense_accounts();
global $service;

for($x=0; $x<count($adsenseaccounts); $x++) {

	// We need to loop through each adsense account thats active and retrieve the rpm / estimated earnings for each and record that data
	list($client_id,$client_secret,$token,$refreshtoken,$created,$gcID,$adsenseAccount) = get_google_adsense_creds($adsenseaccounts[$x],'adsense');

	require_once 'google-api-php-client/src/Google/autoload.php';
#	session_start();

	$client = new Google_Client();
        $client->setClientId($client_id);
        $client->setClientSecret($client_secret);
        $client->setRedirectUri($redirect_uri);
        $client->setScopes(array('https://www.googleapis.com/auth/adsense'));
        $client->setScopes(array('https://www.googleapis.com/auth/adsense.readonly'));
        $client->setAccessType('offline');   // Gets us our refreshtoken
        $client->setApprovalPrompt('force');

        // Check if token has expired or not
        if($client->isAccessTokenExpired()) {

                // if yes we need to update token with the refreshtoken var
                $client->refreshToken($refreshtoken);
                $newtoken = $client->getAccessToken();
#               print_r($newtoken);
#               echo '<br>Refreshed<br>';

        } else {

                // if token hasnt expired use previous token
                $client->setAccessToken($token);

        }


        $service = new Google_Service_AdSense($client);

	// Report will be based on todays date (need to put it into adsense billing timezone (19 hours behind sydney time (daylight savings))
	$startDate = date('Y-m-d', strtotime("-19 hours"));
	$endDate = date('Y-m-d', strtotime("-19 hours")); 
/*
    $optParams = array(
      'metric' => array(
        'PAGE_VIEWS_RPM', 'EARNINGS'),
      'dimension' => 'DOMAIN_NAME'
#      'sort' => '+DATE'
#      'filter' => array(
#        'AD_CLIENT_ID==' . $adClientId
#      )
    );
*/

/*
    // Run report.
    $report = $service->accounts_reports->generate($adsenseAccount, $startDate,
        $endDate, $optParams);

    if (isset($report) && isset($report['rows'])) {

	// Attempt to retrieve currency metric from the headers
	// Page views RPm Currency
	if($report['headers'][1]['name'] == "PAGE_VIEWS_RPM" && $report['headers'][1]['type'] == "METRIC_CURRENCY") {
		$pageviewsrpm_currency = $report['headers'][1]['currency'];
	}

	// Estimated Earnings Currency
	if($report['headers'][2]['name'] == "EARNINGS" && $report['headers'][2]['type'] == "METRIC_CURRENCY") {
		$estimatedearnings_currency = $report['headers'][2]['currency'];
	}

	// Process each row of data for each domain
	for($y=0; $y<$report['totalMatchedRows']; $y++) {

		$domain = $report['rows'][$y][0];
		$pagerpm = $report['rows'][$y][1];
		$estimatedearnings = $report['rows'][$y][2];

		echo "Account:".$adsenseaccounts[$x].",Domain:$domain,RPM:$pagerpm [$pageviewsrpm_currency],EstimatedEarnings:$estimatedearnings [$estimatedearnings_currency]<br>";
		adsense_record_pagerpm_earnings($domain,$pagerpm,$pageviewsrpm_currency,$estimatedearnings,$estimatedearnings_currency,$adsenseaccounts[$x]);

	}

		echo "Today Est Earnings : $".$report['totals'][2]."<br>";
		adsense_record_todayest($adsenseaccounts[$x],$report['totals'][2]);
		
      // Display headers.
    } else {
      print "No rows returned.\n";
    }
*/

	// Process Adsense Reporting - Retrieve Yesterday Earnings
	$startDate = date('Y-m-d', strtotime("-1 Days -19 hours"));
	$endDate = date('Y-m-d', strtotime("-1 Days -19 hours"));
	$yesterday_est = adsense_get_earnings($adsenseAccount,$startDate,$endDate,$adsenseaccounts[$x],'Yesterday');

	// Process Adsense Reporting - Retrieve Last 7 days earnings
        $endDate = date('Y-m-d', strtotime("-1 Days -19 hours"));
        $startDate = date('Y-m-d', strtotime("-7 Days -19 hours"));
        $lastseven_est = adsense_get_earnings($adsenseAccount,$startDate,$endDate,$adsenseaccounts[$x],'Last 7');

	// Process Adsense Reporting - Retrieve Last 28 days earnings
        $endDate = date('Y-m-d', strtotime("-1 Days -19 hours"));
        $startDate = date('Y-m-d', strtotime("-30 Days -19 hours"));
        $lastthirty_est = adsense_get_earnings($adsenseAccount,$startDate,$endDate,$adsenseaccounts[$x],'Last 30');

	$fp = fopen('adsense-record-reports.log','a+');
	fwrite($fp, date('Y-m-d H:i:s')." - Account [".$adsenseaccounts[$x]."] PubID [".$adsenseAccount."] Yesterday [".$yesterday_est."] Last 7 [".$lastseven_est."] Last 30 [".$lastthirty_est."]\n");
	fclose($fp);
	// Record yesterday / last 7 and last thirty estimated amount reports
	adsense_record_reports($adsenseaccounts[$x],$yesterday_est,$lastseven_est,$lastthirty_est);

}
